//
//  CSResourceHolder.h
//  CSApp
//
//  Created by Chris Suter on 15/05/13.
//  Copyright (c) 2013 Coriolis Systems Ltd. All rights reserved.
//

/* This class provides a simple wrapper around a resource and calls
   the release function or method when deallocated.  Have a look in iPartition
   for typical usage. */

#import <Foundation/Foundation.h>

typedef void (*CSReleaseFunction)(void *);

@interface CSResourceHolder : NSObject {
  void *_resource;
  CSReleaseFunction _releaseFunction;
  SEL _releaseMethod;
}

- (CSResourceHolder *)initWithResource:(void *)resource
		     releaseFunction:(void *)releaseFunction;
- (CSResourceHolder *)initWithObject:(id)object
		       releaseMethod:(SEL)releaseMethod;
+ (CSResourceHolder *)holderWithResource:(void *)resource
			 releaseFunction:(void *)releaseFunction;
+ (CSResourceHolder *)holderWithObject:(id)object
			 releaseMethod:(SEL)releaseMethod;

- (void *)resource;
- (void)releaseResource;

@end
